//
//  IHRBlueListVC.m
//
//

#import "IHRBlueListVC.h"
#import "IHRBLEManager.h"

@interface IHRBlueListVC ()<UITableViewDelegate, UITableViewDataSource, IHRBLEManagerDelegate>

@property (weak, nonatomic) IBOutlet UITableView *myTable;
@property (strong, nonatomic) NSMutableArray *dataArr;
@property (strong, nonatomic) NSMutableArray *rssiList;
@property (strong, nonatomic) UIActivityIndicatorView *indicator;

@end

@implementation IHRBlueListVC

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.automaticallyAdjustsScrollViewInsets = NO;
    
    [IHRBLEManager sharedInstance].delegate = self;
    [[IHRBLEManager sharedInstance] startScan];
    
    _indicator = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleGray];
    _indicator.center = self.view.center;
    [self.view addSubview:self.indicator];
}

- (void)viewDidDisappear:(BOOL)animated {
    [super viewDidDisappear:animated];
    [[IHRBLEManager sharedInstance] removeDelegate:self];
}


#pragma mark - IHRBLEManagerDelegate

- (void)IHRbleUpdatePeripheralList:(NSArray *)peripherals RSSIList:(NSArray *)rssiList {
    _dataArr = [NSMutableArray arrayWithArray:peripherals];
    _rssiList = [NSMutableArray arrayWithArray:rssiList];
    [_myTable reloadData];
}

- (void)IHRbleConnectPeripheral:(CBPeripheral *)peripheral {
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1.0 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self.indicator stopAnimating];
        [[NSNotificationCenter defaultCenter] postNotificationName:@"IHR_CONNECTION_BT" object:nil];
        [self.navigationController popViewControllerAnimated:YES];
    });
}

- (void)IHRbleFailToConnectPeripheral:(CBPeripheral *)peripheral error:(NSError *)error {
    [self.indicator stopAnimating];
    [self.view makeToast:@"connect fail" duration:1.f position:CSToastPositionCenter];
}


#pragma mark - UITableViewDelegate

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataArr.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellId = @"printerCell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellId];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:cellId];
    }
    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    
    if (indexPath.row < self.dataArr.count) {
        CBPeripheral *peripheral = self.dataArr[indexPath.row];
        cell.textLabel.text = peripheral.name;
        if (peripheral.name.length == 0) {
            cell.textLabel.text = @"unknow";
        }
    }
    
    if (indexPath.row < self.rssiList.count) {
        NSNumber *rssi = self.rssiList[indexPath.row];
        cell.detailTextLabel.text = [NSString stringWithFormat:@"RSSI:%zd",rssi.integerValue];
    }
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    return 100;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    CBPeripheral *peripheral = self.dataArr[indexPath.row];
    [self.indicator startAnimating];

    [[IHRBLEManager sharedInstance] connectDevice:peripheral];
}

- (IBAction)scanAgain:(id)sender {
    [self.dataArr removeAllObjects];
    [[IHRBLEManager sharedInstance] startScan];
}

#pragma mark - lazy
- (NSMutableArray *)dataArr {
    if (!_dataArr) {
        _dataArr = [NSMutableArray array];
    }
    return _dataArr;
}

@end
